/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.step.core.history;

import filenet.vw.toolkit.runtime.step.core.history.VWParticipantHistoryRowItem;
import filenet.vw.toolkit.runtime.step.resources.VWResource;

class VWRowItemToolTip {
    private static final int MAX_TOOLTIP_WIDTH = 80;

    public static String createToolTip(VWParticipantHistoryRowItem rowItem) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        VWRowItemToolTip.addOccurrence(buffer, rowItem.getStepName());
        VWRowItemToolTip.addOccurrence(buffer, rowItem.getOccurrence());
        VWRowItemToolTip.addParticipantName(buffer, rowItem.getParticipantName());
        VWRowItemToolTip.addCompletionDate(buffer, rowItem.getCompletionDate());
        VWRowItemToolTip.addResponse(buffer, rowItem.getResponse());
        VWRowItemToolTip.addComments(buffer, rowItem.getComments());
        buffer.append("</html>");
        return buffer.toString();
    }

    private static void addOccurrence(StringBuffer buffer, String stepName) {
        buffer.append("<B>");
        buffer.append(VWResource.s_colon.toString(VWResource.s_step));
        buffer.append("</B>");
        buffer.append(stepName);
        buffer.append("<BR>");
    }

    private static void addOccurrence(StringBuffer buffer, Integer occurrence) {
        buffer.append("<B>");
        buffer.append(VWResource.s_colon.toString(VWResource.s_occurrence));
        buffer.append("</B>");
        buffer.append(occurrence);
        buffer.append("<BR>");
    }

    private static void addParticipantName(StringBuffer buffer, String name) {
        buffer.append("<B>");
        buffer.append(VWResource.s_colon.toString(VWResource.s_participant));
        buffer.append("</B>");
        buffer.append(VWRowItemToolTip.formatLongString(name));
        buffer.append("<BR>");
    }

    private static void addCompletionDate(StringBuffer buffer, String date) {
        buffer.append("<B>");
        buffer.append(VWResource.s_colon.toString(VWResource.s_completed));
        buffer.append("</B>");
        buffer.append(VWRowItemToolTip.formatLongString(date));
        buffer.append("<BR>");
    }

    private static void addResponse(StringBuffer buffer, String response) {
        buffer.append("<B>");
        buffer.append(VWResource.s_colon.toString(VWResource.s_response));
        buffer.append("</B>");
        buffer.append(VWRowItemToolTip.formatLongString(response));
        buffer.append("<BR>");
    }

    private static void addComments(StringBuffer buffer, String comments) {
        buffer.append("<B>");
        buffer.append(VWResource.s_colon.toString(VWResource.s_comments));
        buffer.append("</B>");
        buffer.append(VWRowItemToolTip.formatLongString(comments));
    }

    private static String formatLongString(String longStr) {
        String formatString = "";
        if (longStr != null) {
            if (longStr.length() <= 80) {
                formatString = longStr;
            } else {
                String tempString = longStr;
                while (tempString.length() > 80) {
                    formatString = formatString + tempString.substring(0, 79) + "<BR>";
                    tempString = tempString.substring(80, tempString.length());
                }
                formatString = formatString + tempString;
            }
        }
        return formatString;
    }
}

